
# here we define what char to use as float seperator for the dsn
set sql_db_ratesep ","


proc sql:check_value {value type length} {
	if {$type == "BIT"} {if {$value != "0" && $value != "1"} {set value 0}} elseif {$type == "INTEGER"} {if {![string is integer $value]} {set value 0}}
	if {$length != ""} {set value [string range $value 0 [expr {$length-1}]]}
	return [string map {' {}} $value]
}


proc sql:check_datetime {id} {
	return "[string range $id 2 5]-[string range $id 6 7]-[string range $id 8 9] [string range $id 10 11]:[string range $id 12 13]:[string range $id 14 15]"
}


proc sql:check_double {value} {
	if {$value == ""} {return 0${::sql_db_ratesep}0} elseif {![string is double $value]} {return 0${::sql_db_ratesep}0}
	regsub -all -- {\.} $value "$::sql_db_ratesep" value
	
	return $value
}

proc sql:check_rate {rate} {
	if {$rate == ""} {
		return 0
	} elseif {$rate == "0"} {
		return 0
	} elseif {[string length $rate] == 1} {
		return 0${::sql_db_ratesep}0$rate
	} elseif {[string length $rate] == 2} {
		return 0${::sql_db_ratesep}$rate
	} else {
		return "[string range $rate 0 [expr {[string length $rate]-3}]]${::sql_db_ratesep}[string range $rate [expr {[string length $rate]-2}] end]"
	}
}
